<?php

namespace App\Controller;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use App\Model\subscriptionPlanDto;
use App\Entity\SubscriptionPlan;
use App\Entity\Admin;
use OpenApi\Attributes as OA;


use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Subscription Plan')]

final class SubscriptionPlanController extends AbstractController
{ private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }


    #[Route('/subscription-plans/{id}', name: 'app_SubscriptionPlan',  methods: ['GET'])]
    public function get(EntityManagerInterface $entityManager, string $id): Response
    {
        $subscriptionPlan = $entityManager->getRepository(SubscriptionPlan::class);

        return $this->json($subscriptionPlan->find($id));

    }
    #[Route('/subscription-plans', name: 'app_SubscriptionPlan_all',  methods: ['GET'])]
    public function getAll(EntityManagerInterface $entityManager): Response
    {
        $subscriptionPlan = $entityManager->getRepository(SubscriptionPlan::class);

        return $this->json($subscriptionPlan->findAll());
    }

     #[Route('/subscription-plans', name: 'app_SubscriptionPlan_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] SubscriptionPlanDto $payload, ): JsonResponse
    {
      $subscriptionPlan = new SubscriptionPlan();
      $adminRepo = $this->entityManager->getRepository(Admin::class);
     
      $admin = $adminRepo->find($payload->adminId);
      $subscriptionPlan-> setAdminID($admin);
      $subscriptionPlan->setPlanName($payload->planName);
      $subscriptionPlan-> setCost($payload->cost);
      $subscriptionPlan->setDuration($payload->duration);  
      $subscriptionPlan->setCreatedAt(new \DateTimeImmutable);
      
      $this->entityManager->persist($subscriptionPlan);
      $this->entityManager->flush();

      return new JsonResponse('Created succ...' .$subscriptionPlan->getId());
    }
      #[Route('/subscription-plans/{id}', name: 'app_SubscriptionPlan_add', methods: ['PUT'])]
    public function update( #[MapRequestPayload] subscriptionPlanDto $payload, string $id, ): JsonResponse
    { 
        $subscriptionPlan = $this->entityManager->getRepository(SubscriptionPlan::class)->find($id);
        
        if (!$subscriptionPlan) {
            return new JsonResponse([ 'No subscriptionPlan with this id was found'], Response::HTTP_NOT_FOUND);
      
          }
      $adminRepo = $this->entityManager->getRepository(Admin::class);
     
      $admin = $adminRepo->find($payload->adminId);
      $subscriptionPlan-> setAdminID($admin);
      $subscriptionPlan->setPlanName($payload->planName);
      $subscriptionPlan-> setCost($payload->cost);
      $subscriptionPlan->setDuration($payload->duration); 
      $subscriptionPlan->setUpdatedAt(new \DateTimeImmutable);
      
      $this->entityManager->persist($subscriptionPlan);
      $this->entityManager->flush();

      return new JsonResponse('Updated succ...' .$subscriptionPlan->getId());
    }
      #[Route('/subscription-plans/{id}', name: 'SubscriptionPlan_delete', methods: ['DELETE'])]
     public function delete(string $id): JsonResponse
    {
        $subscriptionPlan = $this->entityManager->getRepository(SubscriptionPlan::class);
        
        if (!$subscriptionPlan) {
            return new JsonResponse([ 'No subscriptionPlan with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($subscriptionPlan->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['subscriptionPlan deleted successfully']);
    }
}
