<?php

namespace App\Controller;
use App\Entity\SubscribePlan;
use App\Entity\SubscriptionPlan;
use App\Entity\ServiceProviderProfile;
use SubscribePlan\Model\SubscribePlanDto;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Subscribe Plan')]

final class SubscribePlanController extends AbstractController
{    
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
    }
    #[Route('/subscribe-plans', name: 'app_subscribeplan', methods:['GET'])]
    public function getAll(): JsonResponse
    {
        $subscribeplan = $this->entityManager->getRepository(SubscribePlan::class);
        return $this->Json($subscribeplan->findAll());
    }

    #[Route('/subscribe-plans/{id}', name: 'subscribeplan_show', methods:['GET'])]
    Public function show(string $id): JsonResponse
    {
        $subscribeplan = $this->entityManager->getRepository(SubscribePlan::class)->find($id);

        if(!$subscribeplan){
             return new JsonResponse(['message'=>'No SubscribePlan with this id found'], Response::HTTP_NOT_FOUND);
        }
        return $this->json($subscribeplan);
    }

    #[Route('/subscribe-plans', name: 'subscribeplan_create', methods: ['POST'])]
    public function create(#[MapRequestPayload] SubscribePlanDto $payload, ): Jsonresponse
    {
      $subscribeplan= new SubscribePlan();
       $splanRepo = $this->entityManager->getRepository(SubscriptionPlan::class);
      $splan = $splanRepo->find($payload->subscriptionPlanId);

       $spRepo = $this->entityManager->getRepository(ServiceProviderProfile::class);
      $sp = $spRepo->find($payload->serviceProviderId);
     

      $subscribeplan->setServiceProviderID($sp);
      $subscribeplan->setSubscriptionPlanId($splan);
      $subscribeplan->setStartDate($payload->startDate);
      $subscribeplan->setEndDate($payload->endDate);
      $subscribeplan->setStatus($payload->status);
      $subscribeplan->setRenewAt(new \DateTimeImmutable());
      $subscribeplan->setCreatedAt(new \DateTimeImmutable());
    

      $this->entityManager->persist($subscribeplan);
      $this->entityManager->flush();

       return new JsonResponse(['message' => 'SubscribePlan created successfully' .$subscribeplan->getId()]);

    }

     #[Route('/subscribe-plans/{id}', name: 'subscribeplan_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] SubscribePlanDto $payload, ): JsonResponse
    {
        $subscribeplan = $this->entityManager->getRepository(SubscribePlan::class)->find($id);

        if (!$subscribeplan) {
            return new JsonResponse(['message' => 'No SubscribePlan with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $splanRepo = $this->entityManager->getRepository(SubscriptionPlan::class);
        $splan = $splanRepo->find($payload->subscriptionPlanId);

        $spRepo = $this->entityManager->getRepository(ServiceProviderProfile::class);
        $sp = $spRepo->find($payload->serviceProviderId);

        $subscribeplan->setServiceProviderID($sp);
        $subscribeplan->setSubscriptionPlanId($splan);
        $subscribeplan->setStartDate($payload->startDate);
        $subscribeplan->setEndDate($payload->endDate);
        $subscribeplan->setStatus($payload->status);
        $subscribeplan->setRenewAt(new \DateTimeImmutable());
        $subscribeplan->setUpdatedAt(new \DateTimeImmutable());
            

        $this->entityManager->flush();

        return new JsonResponse(['message' => 'SubscribePlan updated successfully' .$subscribeplan->getId()]);
    }

    #[Route('/subscribe-plans/{id}', name: 'subscribeplan_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $subscribePlan = $this->entityManager->getRepository(SubscribePlan::class);
        
        if (!$subscribePlan) {
            return new JsonResponse(['message' => 'No Subscribe Plan with this id was found'], Response::HTTP_NOT_FOUND);
        }
    
        $this->entityManager->remove($subscribePlan->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Subscribe Plan deleted successfully']);
    }

}
