<?php

namespace App\Controller;
use App\Entity\ServiceProviderProfile;
use App\Entity\Users;
use ServiceProviderProfile\Model\ServiceProviderProfileDto;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Service Provider Profile')]

final class ServiceProviderProfileController extends AbstractController
{    
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
    }
    #[Route('/service-provider-profiles', name: 'app_serviceproviderprofile', methods:['GET'])]
    public function getAll(): JsonResponse
    {
        $serviceProviderProfile= $this->entityManager->getRepository(ServiceProviderProfile::class);
        return $this->Json($serviceProviderProfile->findAll());
    }

    #[Route('/service-provider-profiles/{id}', name: 'serviceproviderprofile_show', methods:['GET'])]
    Public function show(string $id): JsonResponse
    {
        $serviceProviderProfile = $this->entityManager->getRepository(ServiceProviderProfile::class)->find($id);

        if(!$serviceProviderProfile){
             return new JsonResponse(['message'=>'No ServiceProviderProfile with this id found'], Response::HTTP_NOT_FOUND);
        }
        return $this->json($serviceProviderProfile);
    }

    #[Route('/service-provider-profiles', name: 'serviceproviderprofile_create', methods: ['POST'])]
    public function create(#[MapRequestPayload] ServiceProviderProfileDto $payload, ): Jsonresponse
    {
      $serviceproviderprofile= new ServiceProviderProfile();
      $userRepo = $this->entityManager->getRepository(Users::class);
      $user = $userRepo->find($payload->userId);
      

      $serviceproviderprofile->setName($payload->name);
      $serviceproviderprofile->setProfilePic($payload->profilePic);
      $serviceproviderprofile->setType($payload->type);
      $serviceproviderprofile->setBio($payload->bio);
      $serviceproviderprofile->setUserId($user);
      
      $serviceproviderprofile->setStatus($payload->status);
      $serviceproviderprofile->setPhone($payload->phone);
      $serviceproviderprofile->setWebsite($payload->website);
      $serviceproviderprofile->setLinkedIn($payload->linkedIn);
      $serviceproviderprofile->setFacebook($payload->facebook);
      
      $serviceproviderprofile->setCreatedAt(new \DateTimeImmutable());
    

      $this->entityManager->persist($serviceproviderprofile);
      $this->entityManager->flush();

       return new JsonResponse(['message' => 'ServiceProviderProfile created successfully' .$serviceproviderprofile->getId()]);

    }

     #[Route('/service-provider-profiles/{id}', name: 'serviceproviderprofile_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] ServiceProviderProfileDto $payload, ): JsonResponse
    {
        $serviceProviderProfile = $this->entityManager->getRepository(ServiceProviderProfile::class)->find($id);
        
        if (!$serviceProviderProfile) {
            return new JsonResponse(['message' => 'No ServiceProviderProfile with this id was found'], Response::HTTP_NOT_FOUND);
        }
         $userRepo = $this->entityManager->getRepository(Users::class);
      $user = $userRepo->find($payload->userId);

      $serviceProviderProfile->setName($payload->name);
      $serviceProviderProfile->setProfilePic($payload->profilePic);
      $serviceProviderProfile->setType($payload->type);
      $serviceProviderProfile->setBio($payload->bio);
      $serviceProviderProfile->setUserId($user);
      $serviceProviderProfile->setStatus($payload->status);
      $serviceProviderProfile->setPhone($payload->phone);
      $serviceProviderProfile->setWebsite($payload->website);
      $serviceProviderProfile->setLinkedIn($payload->linkedIn);
      $serviceProviderProfile->setFacebook($payload->facebook);

      $serviceProviderProfile->setUpdatedAt(new \DateTimeImmutable());
             

        $this->entityManager->flush();

        return new JsonResponse(['message' => 'ServiceProviderProfile updated successfully' .$serviceProviderProfile->getId()]);
    }

    #[Route('/service-provider-profiles/{id}', name: 'serviceproviderprofile_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $serviceProviderProfile = $this->entityManager->getRepository(ServiceProviderProfile::class);
        
        if (!$serviceProviderProfile) {
            return new JsonResponse(['message' => 'no ServiceProviderProfile with this id was found'], Response::HTTP_NOT_FOUND);
        }
        
        $this->entityManager->remove($serviceProviderProfile->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'ServiceProviderProfile deleted successfully']);
    }

}
