<?php

namespace App\Controller;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use App\Model\serviceDomainDto;
use App\Entity\ServiceDomain;
use App\Entity\Admin;
use OpenApi\Attributes as OA;


use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Service Domain')]

final class ServiceDomainController extends AbstractController
{ 
  private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }


    #[Route('/service-domains/{id}', name: 'app_ServiceDomain',  methods: ['GET'])]
    public function get(EntityManagerInterface $entityManager, string $id): Response
    {
        $serviceDomain = $entityManager->getRepository(ServiceDomain::class);

        return $this->json($serviceDomain->find($id));

    }
    #[Route('/service-domains', name: 'app_ServiceDomain_all',  methods: ['GET'])]
    public function getAll(EntityManagerInterface $entityManager): Response
    {
        $serviceDomain = $entityManager->getRepository(ServiceDomain::class);

        return $this->json($serviceDomain->findAll());
    }

     #[Route('/service-domains', name: 'app_ServiceDomain_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] serviceDomainDto $payload, ): JsonResponse
    {
      $serviceDomain = new ServiceDomain();
      $adminRepo = $this->entityManager->getRepository(Admin::class);
     
      $admin = $adminRepo->find($payload->adminId);

      $serviceDomain-> setAdminId($admin);
      $serviceDomain->setName($payload->name);
      $serviceDomain-> setThumbnail($payload->thumbnail);
      $serviceDomain->setDescription($payload->description);  
      $serviceDomain->setCreatedAt(new \DateTimeImmutable);
      
      $this->entityManager->persist($serviceDomain);
      $this->entityManager->flush();

      return new JsonResponse('Created succ...' .$serviceDomain->getId());
    }
      #[Route('/service-domains/{id}', name: 'app_ServiceDomain_add', methods: ['PUT'])]
    public function update( #[MapRequestPayload] serviceDomainDto $payload, string $id, ): JsonResponse
    { 
      $serviceDomain = $this->entityManager->getRepository(ServiceDomain::class)->find($id);

      if (!$serviceDomain) {
      return new JsonResponse([ 'No serviceDomain with this id was found'], Response::HTTP_NOT_FOUND);

      }
      $adminRepo = $this->entityManager->getRepository(Admin::class);

      $admin = $adminRepo->find($payload->adminId);

      $serviceDomain-> setAdminId($admin);
      $serviceDomain->setName($payload->name);
      $serviceDomain-> setThumbnail($payload->thumbnail);
      $serviceDomain->setDescription($payload->description);  
      $serviceDomain->setUpdatedAt(new \DateTimeImmutable);

      $this->entityManager->persist($serviceDomain);
      $this->entityManager->flush();

      return new JsonResponse('Updated succ...' .$serviceDomain->getId());
    }
      #[Route('/service-domains/{id}', name: 'serviceDomain_delete', methods: ['DELETE'])]
     public function delete(string $id): JsonResponse
    {
      $serviceDomain = $this->entityManager->getRepository(ServiceDomain::class);

      if (!$serviceDomain) {
        return new JsonResponse([ 'No serviceDomain with this id was found'], Response::HTTP_NOT_FOUND);
      }

      $this->entityManager->remove($serviceDomain->find($id));
      $this->entityManager->flush();

        return new JsonResponse(['ServiceDomain deleted successfully']);
    }
}
