<?php

namespace App\Controller;
use App\Entity\Service;
use App\Entity\ServiceCategory;
use App\Entity\ServiceProviderProfile;
use Service\Model\ServiceDto;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Service')]

final class ServiceController extends AbstractController
{    
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
    }
    #[Route('/services', name: 'app_service', methods:['GET'])]
    public function getAll(): JsonResponse
    {
        $service = $this->entityManager->getRepository(Service::class);
        return $this->Json($service->findAll());
    }

    #[Route('/services/{id}', name: 'service_show', methods:['GET'])]
    Public function show(string $id): JsonResponse
    {
        $service = $this->entityManager->getRepository(Service::class)->find($id);

        if(!$service){
             return new JsonResponse(['message'=>'No Service with this id found'], Response::HTTP_NOT_FOUND);
        }
        return $this->json($service);
    }

    #[Route('/services', name: 'service_create', methods: ['POST'])]
    public function create(#[MapRequestPayload] ServiceDto $payload, ): Jsonresponse
    {
        $service= new Service();

        $scRepo = $this->entityManager->getRepository(ServiceCategory::class);
        $sc = $scRepo->find($payload->serviceCategoryId);

        $spRepo = $this->entityManager->getRepository(ServiceProviderProfile::class);
        $sp = $spRepo->find($payload->serviceProviderId);

        $service->setServiceProviderId($sp);
        $service->setServiceCategoryId($sc);
        $service->setName($payload->name);
        $service->setDescription($payload->description);
        $service->setCostRange($payload->costRange);
        $service->setCreatedAt(new \DateTimeImmutable());


        $this->entityManager->persist($service);
      $this->entityManager->flush();

       return new JsonResponse(['message' => 'Service created successfully' .$service->getId()]);

    }

     #[Route('/services/{id}', name: 'service_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] ServiceDto $payload, ): JsonResponse
    {
        $service = $this->entityManager->getRepository(Service::class)->find($id);
        
        if (!$service) {
            return new JsonResponse(['message' => 'No Service with this id was found'], Response::HTTP_NOT_FOUND);
        }
        
        $scRepo = $this->entityManager->getRepository(ServiceCategory::class);
        $sc = $scRepo->find($payload->serviceCategoryId);

        $spRepo = $this->entityManager->getRepository(ServiceProviderProfile::class);
        $sp = $spRepo->find($payload->serviceProviderId);


        $service->setServiceProviderId($sp);
        $service->setServiceCategoryId($sc);
        $service->setName($payload->name);
        $service->setDescription($payload->description);
        $service->setCostRange($payload->costRange);
        $service->setUpdatedAt(new \DateTimeImmutable());


        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Service updated successfully' .$service->getId()]);
    }

    #[Route('/service/{id}', name: 'service_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $service = $this->entityManager->getRepository(Service::class);
        
        if (!$service) {
            return new JsonResponse(['message' => 'No Service with this id was found'], Response::HTTP_NOT_FOUND);
        }
        
        $this->entityManager->remove($service->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Service deleted successfully']);
    }

}
