<?php

namespace App\Controller;
use App\Entity\Feedback;
use App\Entity\ServiceProviderProfile;
use App\Entity\Users;
use Feedback\Model\FeedbackDto;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Feedback')]

final class FeedbackController extends AbstractController
{    
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
    }
    #[Route('/feedbacks', name: 'app_feedback', methods:['GET'])]
    public function getAll(): JsonResponse
    {
        $feedback= $this->entityManager->getRepository(Feedback::class);
        return $this->Json($feedback->findAll());
    }

    #[Route('/feedbacks/{id}', name: 'feedback_show', methods:['GET'])]
    Public function show(string $id): JsonResponse
    {
        $feedback = $this->entityManager->getRepository(Feedback::class)->find($id);

        if(!$feedback){
             return new JsonResponse(['message'=>'No feedback with this id found'], Response::HTTP_NOT_FOUND);
        }
        return $this->json($feedback);
    }

    #[Route('/feedbacks', name: 'feedback_create', methods: ['POST'])]
    public function create(#[MapRequestPayload] FeedbackDto $payload, ): Jsonresponse
    {
        $feedback= new Feedback();
        $userRepo = $this->entityManager->getRepository(Users::class);
        $user = $userRepo->find($payload->userId);

        $spRepo = $this->entityManager->getRepository(ServiceProviderProfile::class);
        $sp = $spRepo->find($payload->serviceProviderId);


        $feedback->setServiceProviderId($sp);
        $feedback->setUserId($user);
        $feedback->setTitle($payload->title);
        $feedback->setComment($payload->comment);
        $feedback->setReply($payload->reply);
        $feedback->setRating($payload->rating);
        $feedback->setBlockedstatus($payload->blockedstatus);


        $feedback->setCreatedAt(new \DateTimeImmutable());


        $this->entityManager->persist($feedback);
        $this->entityManager->flush();

       return new JsonResponse(['message' => 'Feedback created successfully']);

    }

     #[Route('/feedbacks/{id}', name: 'feedback_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] FeedbackDto $payload, ): JsonResponse
    {
        $feedback = $this->entityManager->getRepository(Feedback::class)->find($id);
        
        if (!$feedback) {
            return new JsonResponse(['message' => 'No Feedback with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $userRepo = $this->entityManager->getRepository(Users::class);
        $user = $userRepo->find($payload->userId);

        $spRepo = $this->entityManager->getRepository(ServiceProviderProfile::class);
        $sp = $spRepo->find($payload->serviceProviderId);


        $feedback->setServiceProviderId($sp);
        $feedback->setUserId($user);
        $feedback->setTitle($payload->title);
        $feedback->setComment($payload->comment);
        $feedback->setReply($payload->reply);
        $feedback->setRating($payload->rating);
        $feedback->setBlockedstatus($payload->blockedstatus);


        $feedback->setUpdatedAt(new \DateTimeImmutable());


        $this->entityManager->flush();

        return new JsonResponse(['message' => 'feedback updated successfully' .$feedback->getId()]);
    }

    #[Route('/feedbacks/{id}', name: 'feedback_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $feedback = $this->entityManager->getRepository(Feedback::class);
        
        if (!$feedback) {
            return new JsonResponse(['message' => 'no Feedback with this id was found'], Response::HTTP_NOT_FOUND);
        }
        
        $this->entityManager->remove($feedback->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Feedback deleted successfully' .$feedback->getId()]);
    }

}
