<?php

namespace App\Controller;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use App\Model\chartMessageDto;
use App\Entity\ChartMessage;
use App\Entity\Chart;
use App\Entity\Users;
use OpenApi\Attributes as OA;


use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'ChartMessage')]

final class ChartMessageController extends AbstractController
{ 
    private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }


    #[Route('/chart-messages/{id}', name: 'app_chartMessage',  methods: ['GET'])]
    public function get(EntityManagerInterface $entityManager, string $id): Response
    {
        $chartMessage = $entityManager->getRepository(ChartMessage::class);

        return $this->json($chartMessage->find($id));

    }
    #[Route('/chart-messages', name: 'app_chartMessage_all',  methods: ['GET'])]
    public function getAll(EntityManagerInterface $entityManager): Response
    {
        $chartMessage = $entityManager->getRepository(ChartMessage::class);

        return $this->json($chartMessage->findAll());
    }

     #[Route('/chart-messages', name: 'app_chartMessages_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] chartMessageDto $payload, ): JsonResponse
    {
      $chartMessage = new ChartMessage();
      $chartRepo = $this->entityManager->getRepository(Chart::class);
      $usersRepo = $this->entityManager->getRepository(Users::class);

      $chart = $chartRepo->find($payload->chartUserId);
      $users = $usersRepo->find($payload->userId);

      $chartMessage->setMessage($payload->message);
      $chartMessage-> setStatus($payload->status);
      $chartMessage->setCreatedAt(new \DateTimeImmutable);
      $chartMessage-> setUserId($users); 
      $chartMessage-> setChartUserId($chart); 
      
      $this->entityManager->persist($chartMessage);
      $this->entityManager->flush();

      return new JsonResponse('Created succ...' .$chart->getId());
    }
      #[Route('/chart-messages/{id}', name: 'chartMessages_add', methods: ['PUT'])]
    public function update( #[MapRequestPayload] chartMessageDto $payload, string $id, ): JsonResponse
    { 
        $chartMessage = $this->entityManager->getRepository(ChartMessage::class)->find($id);
        
        if (!$chartMessage) {
            return new JsonResponse([ 'No chartMassage with this id was found'], Response::HTTP_NOT_FOUND);
      
          }
          
      $chartRepo = $this->entityManager->getRepository(Chart::class);
      $usersRepo = $this->entityManager->getRepository(Users::class);

      $chart = $chartRepo->find($payload->chartUserId);
      $users = $usersRepo->find($payload->userId);

      $chartMessage->setMessage($payload->message);
      $chartMessage-> setStatus($payload->status);
      $chartMessage->setUpdatedAt(new \DateTimeImmutable);
      $chartMessage-> setUserId($users); 
      $chartMessage-> setChartUserId($chart); 
      
      $this->entityManager->persist($chartMessage);
      $this->entityManager->flush();

      return new JsonResponse('Updated succ...' .$chartMessage->getId());
    }
      #[Route('/chart-messages/{id}', name: 'chartMessages_delete', methods: ['DELETE'])]
     public function delete(string $id): JsonResponse
    {
        $chartMessage = $this->entityManager->getRepository(ChartMessage::class);
        
        if (!$chartMessage) {
            return new JsonResponse([ 'No chartMessage with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($chartMessage->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['chartMessage deleted successfully']);
    }
}
