<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251118201057 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE admin (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', email VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, first_name VARCHAR(100) NOT NULL, status VARCHAR(100) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE chart (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_E5562A2A9D86650F (user_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE chart_message (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', chart_user_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', message VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_FB6D6A0B8F9C2C4 (chart_user_id_id), INDEX IDX_FB6D6A0B9D86650F (user_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE feedback (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', service_provider_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', title VARCHAR(255) NOT NULL, comment VARCHAR(255) NOT NULL, reply VARCHAR(255) NOT NULL, rating VARCHAR(255) NOT NULL, blockedstatus VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', UNIQUE INDEX UNIQ_D229445825747695 (service_provider_id_id), INDEX IDX_D22944589D86650F (user_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE login_attempts (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', email VARCHAR(255) NOT NULL, user_agent VARCHAR(255) NOT NULL, ip VARCHAR(100) NOT NULL, is_succes TINYINT(1) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE reset_password (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', email VARCHAR(255) NOT NULL, token VARCHAR(150) NOT NULL, status VARCHAR(100) NOT NULL, notify_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE service (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', service_provider_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', service_category_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, cost_range VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_E19D9AD225747695 (service_provider_id_id), INDEX IDX_E19D9AD294118CA8 (service_category_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE service_category (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', admin_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', servicedomain_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(100) NOT NULL, description VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_FF3A42FCDF6E65AD (admin_id_id), INDEX IDX_FF3A42FC3E1822D3 (servicedomain_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE service_domain (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', admin_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(100) NOT NULL, thumbnail VARCHAR(100) NOT NULL, description VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_996E1B3DDF6E65AD (admin_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE service_portfolio (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', service_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', photo_url VARCHAR(255) DEFAULT NULL, description VARCHAR(255) NOT NULL, title VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_F17C2A28D63673B0 (service_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE service_provider_profile (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, profile_pic VARCHAR(255) NOT NULL, type VARCHAR(255) NOT NULL, bio VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, phone INT NOT NULL, website VARCHAR(255) NOT NULL, linked_in VARCHAR(255) NOT NULL, facebook VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', UNIQUE INDEX UNIQ_D64A2FB99D86650F (user_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE subscribe_plan (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', service_provider_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', subscription_plan_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', start_date DATE NOT NULL, end_date DATE NOT NULL, status VARCHAR(255) NOT NULL, renew_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_6AAB164525747695 (service_provider_id_id), UNIQUE INDEX UNIQ_6AAB1645EE079BCE (subscription_plan_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE subscription_plan (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', admin_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', plan_name VARCHAR(100) NOT NULL, duration VARCHAR(50) NOT NULL, cost INT NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_EA664B63DF6E65AD (admin_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE user_devices (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_agent VARCHAR(150) NOT NULL, ip VARCHAR(100) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_490A50909D86650F (user_id_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE users (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', first_name VARCHAR(100) NOT NULL, last_name VARCHAR(100) NOT NULL, email VARCHAR(255) NOT NULL, password VARCHAR(50) NOT NULL, country VARCHAR(50) NOT NULL, address VARCHAR(100) NOT NULL, account_type VARCHAR(50) NOT NULL, phone_number INT NOT NULL, whatsapp_number INT NOT NULL, notify_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', token VARCHAR(100) NOT NULL, blocked_status VARCHAR(100) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', updated_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', deleted_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE messenger_messages (id BIGINT AUTO_INCREMENT NOT NULL, body LONGTEXT NOT NULL, headers LONGTEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', available_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', delivered_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_75EA56E0FB7336F0 (queue_name), INDEX IDX_75EA56E0E3BD61CE (available_at), INDEX IDX_75EA56E016BA31DB (delivered_at), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE chart ADD CONSTRAINT FK_E5562A2A9D86650F FOREIGN KEY (user_id_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE chart_message ADD CONSTRAINT FK_FB6D6A0B8F9C2C4 FOREIGN KEY (chart_user_id_id) REFERENCES chart (id)');
        $this->addSql('ALTER TABLE chart_message ADD CONSTRAINT FK_FB6D6A0B9D86650F FOREIGN KEY (user_id_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE feedback ADD CONSTRAINT FK_D229445825747695 FOREIGN KEY (service_provider_id_id) REFERENCES service_provider_profile (id)');
        $this->addSql('ALTER TABLE feedback ADD CONSTRAINT FK_D22944589D86650F FOREIGN KEY (user_id_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE service ADD CONSTRAINT FK_E19D9AD225747695 FOREIGN KEY (service_provider_id_id) REFERENCES service_provider_profile (id)');
        $this->addSql('ALTER TABLE service ADD CONSTRAINT FK_E19D9AD294118CA8 FOREIGN KEY (service_category_id_id) REFERENCES service_category (id)');
        $this->addSql('ALTER TABLE service_category ADD CONSTRAINT FK_FF3A42FCDF6E65AD FOREIGN KEY (admin_id_id) REFERENCES admin (id)');
        $this->addSql('ALTER TABLE service_category ADD CONSTRAINT FK_FF3A42FC3E1822D3 FOREIGN KEY (servicedomain_id_id) REFERENCES service_domain (id)');
        $this->addSql('ALTER TABLE service_domain ADD CONSTRAINT FK_996E1B3DDF6E65AD FOREIGN KEY (admin_id_id) REFERENCES admin (id)');
        $this->addSql('ALTER TABLE service_portfolio ADD CONSTRAINT FK_F17C2A28D63673B0 FOREIGN KEY (service_id_id) REFERENCES service (id)');
        $this->addSql('ALTER TABLE service_provider_profile ADD CONSTRAINT FK_D64A2FB99D86650F FOREIGN KEY (user_id_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE subscribe_plan ADD CONSTRAINT FK_6AAB164525747695 FOREIGN KEY (service_provider_id_id) REFERENCES service_provider_profile (id)');
        $this->addSql('ALTER TABLE subscribe_plan ADD CONSTRAINT FK_6AAB1645EE079BCE FOREIGN KEY (subscription_plan_id_id) REFERENCES subscription_plan (id)');
        $this->addSql('ALTER TABLE subscription_plan ADD CONSTRAINT FK_EA664B63DF6E65AD FOREIGN KEY (admin_id_id) REFERENCES admin (id)');
        $this->addSql('ALTER TABLE user_devices ADD CONSTRAINT FK_490A50909D86650F FOREIGN KEY (user_id_id) REFERENCES users (id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE chart DROP FOREIGN KEY FK_E5562A2A9D86650F');
        $this->addSql('ALTER TABLE chart_message DROP FOREIGN KEY FK_FB6D6A0B8F9C2C4');
        $this->addSql('ALTER TABLE chart_message DROP FOREIGN KEY FK_FB6D6A0B9D86650F');
        $this->addSql('ALTER TABLE feedback DROP FOREIGN KEY FK_D229445825747695');
        $this->addSql('ALTER TABLE feedback DROP FOREIGN KEY FK_D22944589D86650F');
        $this->addSql('ALTER TABLE service DROP FOREIGN KEY FK_E19D9AD225747695');
        $this->addSql('ALTER TABLE service DROP FOREIGN KEY FK_E19D9AD294118CA8');
        $this->addSql('ALTER TABLE service_category DROP FOREIGN KEY FK_FF3A42FCDF6E65AD');
        $this->addSql('ALTER TABLE service_category DROP FOREIGN KEY FK_FF3A42FC3E1822D3');
        $this->addSql('ALTER TABLE service_domain DROP FOREIGN KEY FK_996E1B3DDF6E65AD');
        $this->addSql('ALTER TABLE service_portfolio DROP FOREIGN KEY FK_F17C2A28D63673B0');
        $this->addSql('ALTER TABLE service_provider_profile DROP FOREIGN KEY FK_D64A2FB99D86650F');
        $this->addSql('ALTER TABLE subscribe_plan DROP FOREIGN KEY FK_6AAB164525747695');
        $this->addSql('ALTER TABLE subscribe_plan DROP FOREIGN KEY FK_6AAB1645EE079BCE');
        $this->addSql('ALTER TABLE subscription_plan DROP FOREIGN KEY FK_EA664B63DF6E65AD');
        $this->addSql('ALTER TABLE user_devices DROP FOREIGN KEY FK_490A50909D86650F');
        $this->addSql('DROP TABLE admin');
        $this->addSql('DROP TABLE chart');
        $this->addSql('DROP TABLE chart_message');
        $this->addSql('DROP TABLE feedback');
        $this->addSql('DROP TABLE login_attempts');
        $this->addSql('DROP TABLE reset_password');
        $this->addSql('DROP TABLE service');
        $this->addSql('DROP TABLE service_category');
        $this->addSql('DROP TABLE service_domain');
        $this->addSql('DROP TABLE service_portfolio');
        $this->addSql('DROP TABLE service_provider_profile');
        $this->addSql('DROP TABLE subscribe_plan');
        $this->addSql('DROP TABLE subscription_plan');
        $this->addSql('DROP TABLE user_devices');
        $this->addSql('DROP TABLE users');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
